#include "stdafx.h"
#include "CLS_MP4Operation.h"

CLS_MP4Operation* CLS_MP4Operation::m_pInstance = NULL;

CLS_MP4Operation::CLS_MP4Operation()
{
	m_Handler = NULL;
	int iRet = LoadLibMp4();
	if(iRet < 0)
	{
		return;
	}
}

CLS_MP4Operation::~CLS_MP4Operation()
{
	if(NULL != m_Handler && NULL != m_pInstance)
	{
		m_pInstance->FreeLibMp4();
		m_Handler = NULL;
	}
	if(NULL != m_pInstance)
	{
		delete m_pInstance;
		m_pInstance = NULL;
	}
}

CLS_MP4Operation* CLS_MP4Operation::Instance(void)
{
	if(NULL == m_pInstance)
	{
		m_pInstance = new CLS_MP4Operation();
	}
	return m_pInstance;
}

void CLS_MP4Operation::Destroy()
{
	if(NULL != m_pInstance->m_Handler)
	{
		m_pInstance->FreeLibMp4();
		m_pInstance->m_Handler = NULL;
	}
	if(NULL != m_pInstance)
	{
		delete m_pInstance;
		m_pInstance = NULL;
	}
}

int CLS_MP4Operation::LoadLibMp4()
{
	int iRet = -1;
	if(NULL != m_Handler)
	{
		iRet = 0;
		goto EXIT;
	}

	m_Handler = LoadLibrary("libmp4adpter.dll");
	if(NULL == m_Handler)
	{
		iRet = -1;
		goto EXIT;
	}

	m_MP4_IsMP4Format = (pMP4_IsMP4Format)GetProcAddress(m_Handler, "MP4_IsMP4Format");
	m_MP4_Open = (pMP4_Open)GetProcAddress(m_Handler, "MP4_Open");
	m_MP4_Close = (pMP4_Close)GetProcAddress(m_Handler, "MP4_Close");
	m_MP4_GetFileHead = (pMP4_GetFileHead)GetProcAddress(m_Handler, "MP4_GetFileHead");
	m_MP4_GetEncryptStat = (pMP4_GetEncryptStat)GetProcAddress(m_Handler, "MP4_GetEncryptStat");
	m_MP4_GetSignInfo = (pMP4_GetSignInfo)GetProcAddress(m_Handler, "MP4_GetSignInfo");
	m_MP4_Free = (pMP4_Free)GetProcAddress(m_Handler, "MP4_Free");
	m_MP4_Read = (pMP4_Read)GetProcAddress(m_Handler, "MP4_Read");
	m_MP4_Seek = (pMP4_Seek)GetProcAddress(m_Handler, "MP4_Seek");
	m_MP4_CopyMP4FileNoAudio = (pMP4_CopyMP4FileNoAudio)GetProcAddress(m_Handler, "MP4_CopyMP4FileNoAudio");
	iRet = 0;

EXIT:
	return iRet;
}

int CLS_MP4Operation::FreeLibMp4()
{
	int iRet = -1;
	if(NULL == m_Handler)
	{
		goto EXIT;
	}
	if(FreeLibrary(m_Handler))
	{
		m_Handler = NULL;
	}
	iRet = 0;

EXIT:
	return iRet;
}

td_bool CLS_MP4Operation::MP4_IsMP4Format(td_char* _pcFileName)
{
	if(NULL == m_MP4_IsMP4Format)
	{
		return td_false;
	}
	return m_MP4_IsMP4Format(_pcFileName);
}

td_MP4FileHandle* CLS_MP4Operation::MP4_Open (td_char *_pcFileName)
{
	if(NULL == m_MP4_Open)
	{
		return NULL;
	}
	return m_MP4_Open(_pcFileName);
}

td_s32 CLS_MP4Operation::MP4_Close(td_MP4FileHandle *_pMP4fh)
{
	if(NULL == m_MP4_Close)
	{
		return -1;
	}
	return m_MP4_Close(_pMP4fh);
}

td_s32 CLS_MP4Operation::MP4_GetFileHead(td_MP4FileHandle *_pMP4fh, S_FileHeader *_pstMP4FileHead)
{
	if(NULL == m_MP4_GetFileHead)
	{
		return -1;
	}
	return m_MP4_GetFileHead(_pMP4fh, _pstMP4FileHead);
}

td_s32 CLS_MP4Operation::MP4_GetEncryptStat(td_MP4FileHandle *_pMP4fh, int* _piEncryptStat)
{
	if(NULL == m_MP4_GetEncryptStat)
	{
		return -1;
	}
	return m_MP4_GetEncryptStat(_pMP4fh, _piEncryptStat);
}

td_s32 CLS_MP4Operation::MP4_GetSignInfo(td_MP4FileHandle *_pMP4fh, ESignInfo _type, td_void **_pSignData, td_u32 *_dataLen)
{
	if(NULL == m_MP4_GetSignInfo)
	{
		return -1;
	}
	return m_MP4_GetSignInfo(_pMP4fh, _type, _pSignData, _dataLen);
}

td_void CLS_MP4Operation::MP4_Free(td_void *_pAddr)
{
	if(NULL == m_MP4_Free)
	{
		return;
	}
	return m_MP4_Free(_pAddr);
}

td_s32 CLS_MP4Operation::MP4_Read(td_MP4FileHandle *_pMP4fh, td_void *_pFrameBuf, td_u32 _bufLen)
{
	if(NULL == m_MP4_Read)
	{
		return -1;
	}
	return m_MP4_Read(_pMP4fh, _pFrameBuf, _bufLen);
}

td_s32 CLS_MP4Operation::MP4_Seek(td_MP4FileHandle *_pMP4fh, td_u64 _frameId, ESeekOps _type)
{
	if(NULL == m_MP4_Seek)
	{
		return -1;
	}
	return m_MP4_Seek(_pMP4fh, _frameId, _type);
}

td_s32 CLS_MP4Operation::MP4_CopyMP4FileNoAudio(char* _pcSrcFileName, char* _pcDstFileName)
{
	if(NULL == m_MP4_CopyMP4FileNoAudio)
	{
		return -1;
	}
	return m_MP4_CopyMP4FileNoAudio(_pcSrcFileName, _pcDstFileName);
}